package com.example.sefinsa_app.ui.clientes.editar;

import static com.example.sefinsa_app.utilities.BluetoothUtils.context;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosDialogFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesEditarFragment extends Fragment implements AvalesFotosFragment.OnPhotosSelectedListener {

    private ClientesEditarViewModel mViewModel;

    private TextInputLayout tlCliente, tlTelefono, tlDireccion, tlRuta, tlPoblacion, tlColocadora, tlOtrasReferencias, tlGarantias, tlAval, tlDireccionAval,
            tlOtrasReferenciasAval, tlTelefonoAval, tlGarantiasAval;

    private AutoCompleteTextView  rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView, colocadorasAutoCompleteTextView, clientesAutoCompleteTextView, avalesAutoCompleteTextView;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private Button btnEditarCliente, btnUbicacion, btnSubirFotos, btnSubirFotosA;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private ArrayList<Cliente> clientes;
    private ArrayAdapter<Cliente> clientesAdapter;

    private String selectedAval = "";
    private String cliente_id = "";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String aval_id = "";
    private String rutaId_aval = "";
    private String poblacionId_aval = "";
    private String colocadoraId_aval = "";
    private int previousLengthCliente;
    private boolean backSpaceCliente;

    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private int previousLengthAval;
    private boolean backSpaceAval;
    List<MultipartBody.Part> archivosGeneral;
    List<MultipartBody.Part> archivosGeneralAval;

    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;

    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;

    private HashMap<String, String> avalMap;

    String lat = "";
    String lgt = "";
    String latAval = "";
    String lgtAval = "";

    Button btnUbicacionAval;

    FusedLocationProviderClient client;

    public static ClientesEditarFragment newInstance() {
        return new ClientesEditarFragment();
    }
    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(message);

        // Personaliza el título para centrarlo
        TextView title = new TextView(context);
        title.setText("Alerta");
        title.setGravity(Gravity.CENTER);
        title.setTextSize(TypedValue.COMPLEX_UNIT_SP, 20);
        title.setTextColor(ContextCompat.getColor(context, android.R.color.black));
        title.setPadding(0, 20, 0, 20);

        builder.setCustomTitle(title);

        builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // Acciones al hacer clic en Aceptar
            }
        });

        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2,
                                 ArrayList<String> pathsGarantiasAval2,
                                 ArrayList<String> pathsIneAval2,
                                 ArrayList<String> pathsFotoAval2,
                                 ArrayList<String> pathsFachadaAval2,
                                 List<MultipartBody.Part> archivosGeneral2) {


        // Inicializar y limpiar las listas si es necesario
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);

        // Verificar que los datos se han copiado correctamente
        Log.d("LOG_PHOTOS", "this.archivosGeneral AVAL: " + this.archivosGeneral.toString());

        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList<>();
        }
        this.pathsComprobantesAval.clear();

        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList<>();
        }
        this.pathsGarantiasAval.clear();

        // Agregar archivos de las diferentes listas a pathsComprobantesAval

        if (pathsIneAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }

        Log.d("log", "Total de archivos en archivosGeneral: " + archivosGeneral.size());
    }
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_clientes_editar, container, false);
    }
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle bundle = this.getArguments();
        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());
        initElements(view);

        aval_id="";
        rutaId_aval="";
        poblacionId_aval="";
        colocadoraId_aval="";

        Bundle args = getArguments();
        String personJsonString = args.getString("cliente");
        Cliente cliente = Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        int prestan = Integer.parseInt(cliente.getPrestanombre());
        tlCliente.getEditText().setText(cliente.getNombre_completo());
        tlTelefono.getEditText().setText(cliente.getTelefono());
        tlDireccion.getEditText().setText(cliente.getDireccion());
        rutasAutoCompleteTextView.setText(cliente.getNombre_ruta());
        poblacionesAutoCompleteTextView.setText(cliente.getNombre_poblacion());
        colocadorasAutoCompleteTextView.setText(cliente.getNombre_colocadora());
        tlOtrasReferencias.getEditText().setText(cliente.getOtras_referencias());
        tlGarantias.getEditText().setText(cliente.getGarantias());

        btnUbicacion = view.findViewById(R.id.btnUbicacion);
        btnUbicacionAval = view.findViewById(R.id.btnUbicacionAval);

        cliente_id = cliente.getId();
        ruta_id = cliente.getRuta_cliente();
        poblacion_id = cliente.getPoblacion_cliente();
        colocadora_id = cliente.getColocadora_id();


        clientes = new ArrayList<Cliente>();

        bundle = getArguments();
        if (bundle != null) {
            clientes = (ArrayList<Cliente>) bundle.getSerializable("clientes");
        }

        if (clientes == null) {
            clientes = new ArrayList<Cliente>();
        }

        if (clientes.size() == 0) {
            //getClientes();
        }
        clientesAdapter = new ArrayAdapter<Cliente>(getContext(), android.R.layout.simple_dropdown_item_1line, clientes);
        // Corregir el error aquí
        clientesAutoCompleteTextView = view.findViewById(R.id.acNombreCliente);

        if (clientesAutoCompleteTextView != null) {
            clientesAutoCompleteTextView.setThreshold(1);
            clientesAutoCompleteTextView.setAdapter(clientesAdapter);
        }

        clientesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Cliente cliente = clientesAdapter.getItem(i);
                int prestan = Integer.parseInt(cliente.getPrestanombre());
                if (prestan>0) {
                    // Mostrar mensaje de alerta
                    showAlert("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                    tlCliente.getEditText().setText("");
                }
                else {
                    cliente_id = cliente_id;
                    ruta_id = cliente.getRuta_cliente();
                    poblacion_id = cliente.getPoblacion_cliente();
                    colocadora_id = cliente.getColocadora_id();

                    tlTelefono.getEditText().setText(cliente.getTelefono());
                    tlDireccion.getEditText().setText(cliente.getDireccion());
                    tlRuta.getEditText().setText(cliente.getNombre_ruta());
                    tlPoblacion.getEditText().setText(cliente.getNombre_poblacion());
                    tlColocadora.getEditText().setText(cliente.getNombre_colocadora());
                    tlOtrasReferencias.getEditText().setText(cliente.getOtras_referencias());
                    tlGarantias.getEditText().setText(cliente.getGarantias());
                }
            }

        });

        clientesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLengthCliente = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpaceCliente = previousLengthCliente > s.length();

                if (backSpaceCliente && !cliente_id.equals("")) {

                    clientesAutoCompleteTextView.setText("");
                    tlTelefono.getEditText().setText("");
                    tlDireccion.getEditText().setText("");
                    rutasAutoCompleteTextView.setText("");
                    poblacionesAutoCompleteTextView.setText("");
                    colocadorasAutoCompleteTextView.setText("");
                    tlOtrasReferencias.getEditText().setText("");
                    tlGarantias.getEditText().setText("");

                    //cliente_id = "";
                    ruta_id = "";
                    poblacion_id = "";
                    colocadora_id = "";
                }
            }
        });

        avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLengthAval = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpaceAval = previousLengthAval > s.length();

                if (backSpaceAval && !aval_id.equals("")) {

                    avalesAutoCompleteTextView.setText("");
                    tlTelefonoAval.getEditText().setText("");
                    tlDireccionAval.getEditText().setText("");
                    tlOtrasReferenciasAval.getEditText().setText("");
                    tlGarantiasAval.getEditText().setText("");

                    aval_id = "";
                    avalMap = null;

                }
            }
        });

        btnSubirFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ClientesFotosDialogFragment dialogFragment = new ClientesFotosDialogFragment();

                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson(cliente);
                String personJsonString3 = cliente_id;
                String personJsonString4 = "2";
                args.putString("cliente", personJsonString);
                args.putString("clienteId", personJsonString3);
                args.putString("tipo", personJsonString4);

                getCurrentLocation("cliente");

                dialogFragment.setArguments(args);
                dialogFragment.show(getChildFragmentManager(), "ClientesFotosDialog");
            }
        });

        btnSubirFotosA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                getCurrentLocation("aval");
                if (avalMap == null || avalMap.isEmpty()) {
                    Toast.makeText(getContext(), "No hay datos del aval para enviar.", Toast.LENGTH_SHORT).show();

                    aval_id="";
                    dialogFragment.show(getChildFragmentManager(), "AvalesFotosDialog");
                }
                else
                {
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson(avalMap);
                    String personJsonString3 = aval_id;
                    String personJsonString4 = "2";
                    args.putString("aval", personJsonString);
                    args.putString("avalId", personJsonString3);
                    args.putString("tipo", personJsonString4);

                    dialogFragment.setArguments(args);
                    dialogFragment.show(getChildFragmentManager(), "AvalesFotosDialog");
                }
            }
        });

        btnEditarCliente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if(Validator.fieldValidation(tlCliente, "Ingresa un nombre de cliente")
                        && Validator.fieldValidation(tlTelefono, "Ingresa un teléfono")
                        && Validator.fieldValidation(tlDireccion, "Ingresa una dirección")
                        && Validator.fieldValidation(tlRuta, "Ingresa una ruta")
                        && Validator.fieldValidation(tlPoblacion, "Ingresa una población")
                        && Validator.fieldValidation(tlColocadora, "Ingresa una colocadora")
                        && Validator.fieldValidation(tlOtrasReferencias, "Ingresa otras referencias")
                        && Validator.fieldValidation(tlGarantias, "Ingresa las garantías")
                        && Validator.fieldValidation(tlDireccionAval, "Ingresa una dirección al aval")
                        && Validator.fieldValidation(tlTelefonoAval, "Ingresa un teléfono al aval")
                        && Validator.fieldValidation(tlOtrasReferenciasAval, "Ingresa otras referencias al aval")
                        && Validator.fieldValidation(tlGarantiasAval, "Ingresa las garantías del aval")
                ) {
                    ArrayList<String> pathsComprobantesAval2 = new ArrayList<>(); // Tus rutas de archivos
                    ArrayList<String> pathsGarantiasAval2 = new ArrayList<>();
                    ArrayList<String> pathsIneAval2 = new ArrayList<>();
                    ArrayList<String> pathsFotoAval2 = new ArrayList<>();
                    ArrayList<String> pathsFachadaAval2 = new ArrayList<>();
                    List<MultipartBody.Part> archivosGeneral2 = new ArrayList<>(); // Archivos multipart

                    onPhotosSelected(pathsComprobantesAval2, pathsGarantiasAval2, pathsIneAval2, pathsFotoAval2, pathsFachadaAval2, archivosGeneral2);
                }
                if (!tlAval.getEditText().getText().toString().isEmpty() || tlAval.getEditText().getText() != null) {
                    AvalController ac = new AvalController(getContext());
                    String avalId = ac.getAvalByNombre(tlAval.getEditText().getText().toString().toUpperCase());
                    if (!avalId.isEmpty() || avalId != null) {
                        ClienteController cc = new ClienteController(getContext());
                        String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlAval.getEditText().getText().toString().toUpperCase());
                        if (Objects.equals(prestaNombre, "1")) {
                            AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                            b.setTitle("Aviso");
                            b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                            b.setPositiveButton("Aceptar", null);

                            AlertDialog dialog = b.create();
                            dialog.show();
                        } else {
                            editarCliente();
                        }
                    } else {
                        editarCliente();
                    }
                } else {
                    editarCliente();
                }
            }
        });

        btnUbicacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation("cliente");
                btnUbicacion.setText("Ubicación obtenida");
                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
            }
        });

        btnUbicacionAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getCurrentLocation("aval");
                btnUbicacionAval.setText("Ubicación obtenida");
                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
            }
        });

        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if(poblacionesAutoCompleteTextView.getText().toString().length() > 0){
                    poblacionesAutoCompleteTextView.setText("");
                }
                if(colocadorasAutoCompleteTextView.getText().toString().length() > 0){
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if(poblaciones.size() == 0){
            getPoblaciones();
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                if(colocadorasAutoCompleteTextView.getText().toString().length() > 0){
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Colocadora> colocadorasFiltro =
                        colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(poblacion_id))
                                .collect(Collectors.toList());

                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadorasFiltro);
                colocadorasAutoCompleteTextView.setThreshold(1);
                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
            }
        });
        /**
         *  COLOCADORAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if(colocadoras.size() == 0){
            getColocadoras();
        }

        colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {

                Colocadora colocadora = colocadorasAdapter.getItem(i);
                colocadora_id = colocadora.getId();

            }
        });

        setRutaAutoComplete(cliente.getRuta_cliente());

        setPoblacionAutoComplete(cliente.getPoblacion_cliente());

        setColocadoraAutoComplete(cliente.getColocadora_id());

        new GetAvalTask().execute(cliente_id);

        // Base de datos
        SQLiteDatabase db = new DatabaseHelper(requireContext()).getReadableDatabase();

        // Llenar el AutoCompleteTextView
        llenarAutoComplete(db);
    }
    private void setRutaAutoComplete(String rutaId) {
        for (Ruta ruta : rutas) {
            if (ruta.getId().equals(rutaId)) {
                rutasAutoCompleteTextView.setText(ruta.getNombre_ruta() , false);  // Seteamos el nombre
                break;
            }
        }
    }

    private void setPoblacionAutoComplete(String poblacionId) {
        for (Poblacion poblacion : poblaciones) {
            if (poblacion.getId().equals(poblacionId)) {
                poblacionesAutoCompleteTextView.setText(poblacion.getNombre_poblacion(), false);  // Seteamos el nombre
                break;
            }
        }
    }

    private void setColocadoraAutoComplete(String colocadoraId) {
        for (Colocadora colocadora : colocadoras) {
            if (colocadora.getId().equals(colocadoraId)) {
                colocadorasAutoCompleteTextView.setText(colocadora.getNombre_completo(), false);  // Seteamos el nombre
                break;
            }
        }
    }

    private void initElements(View view){
        CurrentFragment.fragment = "ClientesEditarFragment";
        clientesAutoCompleteTextView = view.findViewById(R.id.acNombreCliente);
        rutasAutoCompleteTextView = view.findViewById(R.id.acRutaEditar);
        poblacionesAutoCompleteTextView= view.findViewById(R.id.acPoblacionEditar);
        colocadorasAutoCompleteTextView= view.findViewById(R.id.acColocadoraEditar);
        avalesAutoCompleteTextView= view.findViewById(R.id.acNombreAvalEditar);

        btnEditarCliente = view.findViewById(R.id.btnEditarCliente);
        btnSubirFotos = view.findViewById(R.id.btnSubirFotos);

        tlCliente = view.findViewById(R.id.tlNombreClienteEditar);
        tlTelefono = view.findViewById(R.id.tlTelefonoEditar);
        tlDireccion = view.findViewById(R.id.tlDireccionEditar);
        tlRuta = view.findViewById(R.id.tlRutaEditar);
        tlPoblacion = view.findViewById(R.id.tlPoblacionEditar);
        tlColocadora = view.findViewById(R.id.tlColocadoraEditar);
        tlOtrasReferencias = view.findViewById(R.id.tlOtrasReferenciasEditar);
        tlGarantias = view.findViewById(R.id.tlGarantiasCliente);

        btnSubirFotosA = view.findViewById(R.id.btnSubirFotosAval);

        tlAval = view.findViewById(R.id.tlNombreAvalEditar);
        tlDireccionAval = view.findViewById(R.id.tlDireccionAvalEditar);
        tlTelefonoAval = view.findViewById(R.id.tlTelefonoAvalEditar);
        tlOtrasReferenciasAval = view.findViewById(R.id.tlOtrasReferenciasAvalEditar);
        tlGarantiasAval = view.findViewById(R.id.tlGarantiasAvalEditar);

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());

        /*bytesGarantiasCliente = new ArrayList<byte[]>();
        bytesComprobantesCliente = new ArrayList<byte[]>();*/
        pathsGarantiasCliente = new ArrayList<>();
        pathsComprobantesCliente = new ArrayList<>();

        pathsGarantiasAval = new ArrayList<>();
        pathsComprobantesAval = new ArrayList<>();

        archivosGeneral = new ArrayList<>();
        archivosGeneralAval = new ArrayList<>();
    }

    @SuppressLint("MissingPermission")
    private void getCurrentLocation(String rol) {
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                if (rol.equals("cliente")) {
                                    lat = String.valueOf(location.getLatitude());
                                    lgt = String.valueOf(location.getLongitude());
                                    btnUbicacion.setText("Ubicación obtenida");
                                } else if (rol.equals("aval")) {
                                    latAval = String.valueOf(location.getLatitude());
                                    lgtAval = String.valueOf(location.getLongitude());
                                    btnUbicacionAval.setText("Ubicación obtenida");
                                }


                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        if (Objects.equals(rol, "cliente")) {
                                            lat = String.valueOf(location1.getLatitude());
                                            lgt = String.valueOf(location1.getLongitude());
                                            btnUbicacion.setText("Ubicación obtenida");
                                        } else if (Objects.equals(rol, "aval")) {
                                            latAval = String.valueOf(location1.getLatitude());
                                            lgtAval = String.valueOf(location1.getLongitude());
                                            btnUbicacionAval.setText("Ubicación obtenida");
                                        }

                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    private class GetAvalTask extends AsyncTask<String, Void, HashMap<String, String>> {

        private ProgressDialog progressDialog;

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            // Mostrar un ProgressDialog antes de iniciar la consulta
            progressDialog = new ProgressDialog(requireContext());
            progressDialog.setMessage("Cargando datos...");
            progressDialog.setCancelable(false); // Evitar que se cierre manualmente
            progressDialog.show();
        }

        @Override
        protected HashMap<String, String> doInBackground(String... params) {
            String cliente_id = params[0];
            HashMap<String, String> avalData = new HashMap<>();
            //Log.d("SQLite", "ENTRO EN OBTENER DATOS DE CLIENTE...........................: " + cliente_id);
            //Log.d("SQLite", "ENTRO EN OBTENER DATOS DE AVAL...........................: " + aval_id);
            // Abrir conexión a la base de datos SQLite
            DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursor = null;

            try {
                // Query SQL con LEFT JOIN en ambas tablas
                String query = "SELECT avales.* " +
                        "FROM avales " +
                        "INNER JOIN clientes ON avales.id = clientes.aval_id " +
                        "WHERE clientes.id = ? " + // Usa un marcador de posición para cliente_id
                        "ORDER BY avales.id DESC LIMIT 1";

                // Ejecutar la consulta pasando cliente_id dos veces como parámetro
                cursor = db.rawQuery(query, new String[]{cliente_id});

                // Verificar si se encontraron resultados
                if (cursor != null && cursor.moveToFirst()) {
                    String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                    // Llenar el HashMap con los datos del cursor
                    avalData.put("id", cursor.getString(cursor.getColumnIndexOrThrow("id")));
                    avalData.put("nombre_completo", cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    avalData.put("direccion", cursor.getString(cursor.getColumnIndexOrThrow("direccion")));
                    avalData.put("telefono", cursor.getString(cursor.getColumnIndexOrThrow("telefono")));
                    avalData.put("otras_referencias", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")));
                    avalData.put("garantias", cursor.getString(cursor.getColumnIndexOrThrow("garantias")));
                    avalData.put("ruta_id", cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    avalData.put("poblacion_id", cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    avalData.put("colocadora_id", cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")));
                    avalData.put("carpeta_comprobantes", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")));
                    avalData.put("carpeta_garantias", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")));

                    //Log.d("SQLite", "ID obtenido del cursor...........................: " + id);
                }
                else{
                    //Log.e("SQLite", "ERROR EN EL cursor...........................: ");

                    // Query SQL con LEFT JOIN en ambas tablas
                    String query2 = "SELECT clientes.* " +
                            "FROM clientes " +
                            "WHERE clientes.id = ? " + // Usa un marcador de posición para cliente_id
                            "ORDER BY clientes.id DESC LIMIT 1";

                    // Ejecutar la consulta pasando cliente_id dos veces como parámetro
                    cursor = db.rawQuery(query2, new String[]{cliente_id});

                    // Verificar si se encontraron resultados
                    if (cursor != null && cursor.moveToFirst()) {
                        String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                        String nombre_completo = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                        String idaval = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));

                        //Log.d("SQLite", "ID obtenido del cursor...........................: " + id);
                        //Log.d("SQLite", "nombre_completo obtenido del cursor...........................: " + nombre_completo);
                        //Log.d("SQLite", "idaval obtenido del cursor...........................: " + idaval);
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
                Log.e("GetAvalTask", "Error al consultar los datos del aval: " + e.getMessage());
            } finally {
                // Cerrar cursor y base de datos
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }

            return avalData;
        }

        @Override
        protected void onPostExecute(HashMap<String, String> result) {
            super.onPostExecute(result);

            // Ocultar el ProgressDialog
            if (progressDialog != null && progressDialog.isShowing()) {
                progressDialog.dismiss();
            }

            // Actualizar la interfaz de usuario con los resultados
            if (result != null && !result.isEmpty()) {
                String id = result.get("id");
                String nombreCompleto = result.get("nombre_completo");
                String direccion = result.get("direccion");
                String telefono = result.get("telefono");
                String otrasReferencias = result.get("otras_referencias");
                String garantias = result.get("garantias");
                String rutaId = result.get("ruta_id");
                String poblacionId = result.get("poblacion_id");
                String colocadoraId = result.get("colocadora_id");
                String carpeta_comprobantes = result.get("carpeta_comprobantes");
                String carpeta_garantias = result.get("carpeta_garantias");

                avalMap = new HashMap<>();

                // Llenar el HashMap con los datos del cursor
                avalMap.put("id", id);
                avalMap.put("nombre_completo", nombreCompleto);
                avalMap.put("direccion", direccion);
                avalMap.put("telefono", telefono);
                avalMap.put("otras_referencias", otrasReferencias);
                avalMap.put("garantias", garantias);
                avalMap.put("ruta_id", rutaId);
                avalMap.put("poblacion_id", poblacionId);
                avalMap.put("colocadora_id", colocadoraId);
                avalMap.put("carpeta_comprobantes", carpeta_comprobantes);
                avalMap.put("carpeta_garantias", carpeta_garantias);


                // Actualizar los TextViews con los datos obtenidos
                tlAval.getEditText().setText(nombreCompleto != null ? nombreCompleto : "N/A");
                tlDireccionAval.getEditText().setText(direccion != null ? direccion : "N/A");
                tlTelefonoAval.getEditText().setText(telefono != null ? telefono : "N/A");
                tlOtrasReferenciasAval.getEditText().setText(otrasReferencias != null ? otrasReferencias : "N/A");
                tlGarantiasAval.getEditText().setText(garantias != null ? garantias : "N/A");

                aval_id = result.get("id");
                rutaId_aval = rutaId;
                poblacionId_aval = poblacionId;
                colocadoraId_aval = colocadoraId;

            } else {
                // Si no se encontraron datos, limpiar los campos
                tlAval.getEditText().setText("");
                tlDireccionAval.getEditText().setText("");
                tlTelefonoAval.getEditText().setText("");
                tlOtrasReferenciasAval.getEditText().setText("");
                tlGarantiasAval.getEditText().setText("");

                avalMap = null;

                rutaId_aval = "";
                poblacionId_aval = "";
                colocadoraId_aval = "";
            }
        }
    }


    private void getRutas() {
        // Verificamos si no hay rutas en la base de datos
        if (rutaController.obtener().size() == 0) {

            // Inicializamos Volley para hacer la solicitud a la API
            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                // Creamos el objeto de datos para enviar a la API
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            // Hacemos la solicitud de las rutas
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                // Obtenemos el array de rutas de la respuesta
                                JSONArray data = (JSONArray) response.get("data");

                                // Limpiamos la lista de rutas antes de llenarla con los datos nuevos
                                rutas.clear();

                                // Iteramos sobre la respuesta y agregamos las rutas a la lista
                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);

                                    // Convertimos cada objeto JSON a un objeto Ruta
                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    rutas.add(ruta);  // Agregamos la ruta a la lista
                                    rutaController.nueva(ruta);  // Guardamos la ruta en la base de datos
                                }

                                // Creamos el adaptador con las rutas
                                rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);  // Configuramos el umbral para mostrar sugerencias
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);  // Asignamos el adaptador al primer AutoCompleteTextView

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());
                }
            });

            // Configuramos la política de reintento
            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            // Agregamos la solicitud a la cola de Volley
            requestQueue.add(request);
        } else {
            // Si ya tenemos rutas en la base de datos, las cargamos desde ahí
            rutas = rutaController.obtener();

            // Creamos el adaptador con las rutas
            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);  // Configuramos el umbral para mostrar sugerencias
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);  // Asignamos el adaptador al primer AutoCompleteTextView

        }
    }


    private void getPoblaciones()
    {

        if(poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
                /*  data.put("ruta_id", ruta_id);*/

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                //String data = response.get("data").toString();

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        else{
            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
        }
    }


    private void getColocadoras()
    {
        if(colocadoraController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            /*data.put("ruta_id", ruta_id);
            data.put("poblacion_id", poblacion_id);*/
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);


                                    Gson gson = new Gson();
                                    Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                    colocadoras.add(colocadora);

                                }

                                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
                                colocadorasAutoCompleteTextView.setThreshold(1);
                                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            colocadoras = colocadoraController.obtener();

            colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
            colocadorasAutoCompleteTextView.setThreshold(1);
            colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

        }
    }
    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        List<Map<String, String>> clientes = new ArrayList<>();
        List<Map<String, String>> avales = new ArrayList<>();
        List<Map<String, String>> resultado = new ArrayList<>();

        // Consulta para obtener los clientes (excluyendo nombres nulos o vacíos)
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo " +
                "FROM clientes " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }

        // Consulta para obtener los avales (excluyendo nombres nulos o vacíos)
        String queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo " +
                "FROM avales " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorAvales = db.rawQuery(queryAvales, null);
        if (cursorAvales != null) {
            while (cursorAvales.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }

        // Crear un Set para almacenar los nombres únicos y evitar duplicados
        Set<String> nombresUnicos = new HashSet<>();

        // Filtrar clientes que no están en avales
        Set<String> nombresAvales = new HashSet<>();
        for (Map<String, String> aval : avales) {
            nombresAvales.add(aval.get("nombre_completo"));
        }

        // Agregar clientes que no están en avales
        for (Map<String, String> cliente : clientes) {
            String nombreCliente = cliente.get("nombre_completo");
            if (!nombresAvales.contains(nombreCliente) && !nombresUnicos.contains(nombreCliente)) {
                resultado.add(cliente);
                nombresUnicos.add(nombreCliente); // Agregar al Set de nombres únicos
            }
        }

        // Agregar todos los avales, asegurando que no se repitan
        for (Map<String, String> aval : avales) {
            String nombreAval = aval.get("nombre_completo");
            if (!nombresUnicos.contains(nombreAval)) {
                resultado.add(aval);
                nombresUnicos.add(nombreAval); // Agregar al Set de nombres únicos
            }
        }

        return resultado;
    }


    @SuppressLint("StaticFieldLeak")
    private void llenarAutoComplete(SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>() {
            @Override
            protected List<Map<String, String>> doInBackground(Void... voids) {
                return getClientesYDisponibles(db);
            }

            @Override
            protected void onPostExecute(List<Map<String, String>> datos) {
                List<String> nombres = new ArrayList<>();
                Map<String, Map<String, String>> idMap = new HashMap<>();

                Log.d("DEBUG", "Datos obtenidos para llenar el AutoComplete: " + datos);

                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre != null && !nombre.trim().isEmpty()) {
                        nombres.add(nombre);
                        idMap.put(nombre, registro);
                    }
                }

                ArrayAdapter<String> adapter = new ArrayAdapter<>(requireContext(), android.R.layout.simple_dropdown_item_1line, nombres);
                avalesAutoCompleteTextView.setAdapter(adapter);

                avalesAutoCompleteTextView.setOnItemClickListener((parent, view, position, id) -> {
                    if (!tlAval.getEditText().getText().toString().isEmpty() || tlAval.getEditText().getText() != null) {
                        AvalController ac = new AvalController(getContext());
                        String avalId = ac.getAvalByNombre(tlAval.getEditText().getText().toString().toUpperCase());
                        if (!avalId.isEmpty() || avalId != null) {
                            ClienteController cc = new ClienteController(getContext());
                            String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlAval.getEditText().getText().toString().toUpperCase());
                            if (Objects.equals(prestaNombre, "1")) {
                                AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                                b.setTitle("Aviso");
                                b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                b.setPositiveButton("Aceptar", null);

                                tlAval.getEditText().setText("");

                                AlertDialog dialog = b.create();
                                dialog.show();
                            } else {
                                String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                                Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                                if (seleccionado != null) {
                                    String idSeleccionado = seleccionado.get("id");
                                    String tipoSeleccionado = seleccionado.get("tipo");

                                    if ("aval".equals(tipoSeleccionado)) {
                                        verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                    } else {
                                        aval_id = "";
                                        llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                    }
                                }
                            }
                        } else {
                            String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                            Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                            if (seleccionado != null) {
                                String idSeleccionado = seleccionado.get("id");
                                String tipoSeleccionado = seleccionado.get("tipo");

                                if ("aval".equals(tipoSeleccionado)) {
                                    verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                } else {
                                    aval_id = "";
                                    llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                }
                            }
                        }
                    } else {
                        String nombreSeleccionado = (String) parent.getItemAtPosition(position);
                        Map<String, String> seleccionado = idMap.get(nombreSeleccionado);

                        if (seleccionado != null) {
                            String idSeleccionado = seleccionado.get("id");
                            String tipoSeleccionado = seleccionado.get("tipo");

                            if ("aval".equals(tipoSeleccionado)) {
                                verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                            } else {
                                aval_id = "";
                                llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                            }
                        }
                    }
                });
            }
        }.execute();
    }

    @SuppressLint("StaticFieldLeak")
    private void verificarAvalAsync(SQLiteDatabase db, String idSeleccionado, String tipoSeleccionado) {
        new AsyncTask<Void, Void, String>() {
            @Override
            protected String doInBackground(Void... voids) {
                String nombreCliente = null;
                Cursor cursor = null;
                try {
                    String query = "SELECT clientes.nombre_completo FROM clientes INNER JOIN prestamos on clientes.id = prestamos.cliente_id WHERE prestamos.aval_id = ? AND prestamos.status='0'";
                    cursor = db.rawQuery(query, new String[]{idSeleccionado});

                    if (cursor != null && cursor.moveToFirst()) {
                        nombreCliente = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                    }
                } catch (Exception e) {
                    Log.e("DEBUG", "Error al verificar si el aval está asociado", e);
                } finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                return nombreCliente;
            }

            @Override
            protected void onPostExecute(String nombreCliente) {
                if (nombreCliente != null) {
                    new AlertDialog.Builder(getContext())
                            .setTitle("Aviso")
                            .setMessage("Este aval ya está ligado al cliente: " + nombreCliente + ". ¿Desea continuar?")
                            .setCancelable(false)
                            .setPositiveButton("Sí", (dialog, which) -> {
                                llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                aval_id = idSeleccionado;
                            })
                            .setNegativeButton("No", (dialog, which) -> {
                                dialog.dismiss();
                            })
                            .show();
                } else {
                    llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                }
            }
        }.execute();
    }
    @SuppressLint("StaticFieldLeak")
    private void llenarCamposAsync(SQLiteDatabase db, String id, String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>() {
            @Override
            protected Map<String, String> doInBackground(Void... voids) {
                Map<String, String> resultado = new HashMap<>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, " +
                        "carpeta_comprobantes, carpeta_garantias " +
                        "FROM " + tabla + " WHERE id = ?";

                Log.d("DEBUG", "Ejecutando query asincrónica para llenar campos: " + query);

                Cursor cursor = db.rawQuery(query, new String[]{id});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("carpeta_comprobantes", cursor.getString(6));
                    resultado.put("carpeta_garantias", cursor.getString(7));

                    aval_id = id; // Asignar aval_id

                    cursor.close();
                }

                return resultado;
            }

            @Override
            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    if (tipo.equals("cliente")) {
                        aval_id = "";
                        avalMap = null; // Reiniciar el HashMap si es cliente
                        Log.d("DEBUG", "Ejecutando query para llenar campos SIN AVAL: " + aval_id);
                    }
                    avalMap = (HashMap<String, String>) resultado; // Asignar al HashMap
                    selectedAval = id;  // Asignar el ID seleccionado

                    tlDireccionAval.getEditText().setText(resultado.get("direccion"));
                    tlTelefonoAval.getEditText().setText(resultado.get("telefono"));
                    tlGarantiasAval.getEditText().setText(resultado.get("garantias"));
                    tlOtrasReferenciasAval.getEditText().setText(resultado.get("otras_referencias"));

                    Log.d("DEBUG", "Contenido de avalMap: " + avalMap + " tipo: " + tipo);


                }
            }
        }.execute();
    }


    private void editarCliente() {

        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);


        // Recoger los demás campos como antes
        String nombre = tlCliente.getEditText().getText().toString().trim();
        String nombreFormateado = nombre.replace("ñ", "n").replace("Ñ", "N").toUpperCase();

        String direccion = tlDireccion.getEditText().getText().toString();
        String telefono = tlTelefono.getEditText().getText().toString();
        String orCliente = tlOtrasReferencias.getEditText().getText().toString();
        String garantias = tlGarantias.getEditText().getText().toString();

        String nombreAv = tlAval.getEditText().getText().toString().trim();
        String nombreAvFormateado = nombreAv.replace("ñ", "n").replace("Ñ", "N").toUpperCase();
        String direccionAv = tlDireccionAval.getEditText().getText().toString();
        String telefonoAv = tlTelefonoAval.getEditText().getText().toString();
        String orAv = tlOtrasReferenciasAval.getEditText().getText().toString();
        String garantiasAv = tlGarantiasAval.getEditText().getText().toString();

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "editAPP");
        RequestBody clienteId =  RequestBody.create(MediaType.parse("multipart/form-data"), cliente_id);
        RequestBody nombre_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), nombreFormateado);
        RequestBody direccion_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), tlDireccion.getEditText().getText().toString());
        RequestBody telefono_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), tlTelefono.getEditText().getText().toString());
        RequestBody or_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), tlOtrasReferencias.getEditText().getText().toString());
        RequestBody colocadoraId =  RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_id);
        RequestBody rutaId =  RequestBody.create(MediaType.parse("multipart/form-data"), ruta_id);
        RequestBody poblacionId =  RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_id);
        RequestBody garantias_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), tlGarantias.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasCliente.size()+"");
        RequestBody cantidad_archivos_cliente =  RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesCliente.size()+"");

        RequestBody latitud = RequestBody.create(MediaType.parse("multipart/form-data"), lat);
        RequestBody longitud = RequestBody.create(MediaType.parse("multipart/form-data"), lgt);

        RequestBody latitudAval = RequestBody.create(MediaType.parse("multipart/form-data"), latAval);
        RequestBody longitudAval = RequestBody.create(MediaType.parse("multipart/form-data"), lgtAval);

        RequestBody avalId =  RequestBody.create(MediaType.parse("multipart/form-data"), aval_id);
        RequestBody nombre_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), nombreAvFormateado);
        RequestBody direccion_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody garantias_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), tlGarantiasAval.getEditText().getText().toString());

        RequestBody ruta_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), ruta_id);
        RequestBody poblacion_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_id);
        RequestBody colocadora_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_id);

        RequestBody cantidad_archivos_garantias_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size()+"");
        RequestBody cantidad_archivos_aval =  RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size()+"");

        Log.d("ARCHIVOS", "archivosGeneral....................." + archivosGeneral.toString());
        Log.d("ARCHIVOS", "rutaId_CLIENTE....................." + ruta_id);
        Log.d("ARCHIVOS", "rutaId_aval....................." + ruta_id);
        Log.d("ARCHIVOS", "poblacionId_aval................." + poblacion_id);
        Log.d("ARCHIVOS", "colocadoraId_aval..............." + colocadora_id);

        Call<ResponseMe> call = retrofitInterface.editarCliente(archivosGeneral, func, clienteId, nombre_cliente, direccion_cliente, telefono_cliente, or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, avalId, nombre_aval, direccion_aval, telefono_aval, or_aval, garantias_aval, latitud, longitud,ruta_aval,poblacion_aval,colocadora_aval, latitudAval, longitudAval);
        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    Log.d("response", response.body().getMessage());
                    String updatedAt = response.body().getData().getUpdated_at(); // Aquí es donde tomas el valor

                    Log.d("Updated At", "Updated At Cliente y Aval...................." + updatedAt); // Solo para verificar en log
                    //Toast.makeText(getActivity(), "El cliente se ha editado", Toast.LENGTH_LONG).show();

                    String idAval = response.body().getData().getAvalID(); // Aquí es donde tomas el valor

                    Log.d("Updated At", "ANTES idAval DEVUELTO POR EL SERVIDOR..................." + idAval); // Solo para verificar en log
                    Log.d("Updated At", "ANTES aval_id At Cliente y Aval ID AVAL: aval_id...................." + aval_id); // Solo para verificar en log

                    // Crear un MaterialAlertDialog personalizado
                    LayoutInflater inflater = getLayoutInflater();
                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                    // Encuentra el TextView y asigna el texto dinámico
                    TextView messageText = dialogView.findViewById(R.id.message_text);
                    messageText.setText("Se editaron los datos correctamente."); // Texto dinámico

                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                    builder.setView(dialogView); // Usa el layout personalizado

                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();

                    // Actualiza la base de datos SQLite
                    actualizarAvalEnSQLite(nombreAvFormateado, direccionAv, telefonoAv, orAv, garantiasAv, ruta_id, poblacion_id, colocadora_id, updatedAt, "on", idAval);
                    actualizarClienteEnSQLite(cliente_id, nombreFormateado, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id, updatedAt, "on", idAval);
                    dialog.cancel();

                    lat = "";
                    lgt = "";
                    btnUbicacion.setText("OBTENER UBICACIÓN");

                    // Cerrar automáticamente el diálogo después de 3 segundos
                    new Handler().postDelayed(() -> {
                        confirmationDialog.dismiss(); // Cerrar el diálogo después de 3 segundos

                        // Realizar la navegación después de que el diálogo se haya cerrado
                        NavOptions navOptions = new NavOptions.Builder()
                                .setPopUpTo(R.id.nav_clientes, true) // Se asegura de que el fragmento nav_clientes sea el principal
                                .build();

                        // Navegar al fragmento nav_clientes
                        Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_clientes, null, navOptions);
                    }, 3000); // Retardo de 3 segundos antes de la navegación
                } else {

                    try {
                        JSONObject jObjError = new JSONObject(response.errorBody().string());

                        new MaterialAlertDialogBuilder(getActivity())
                                .setTitle("Aviso")
                                .setMessage(jObjError.getString("message"))
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();

                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                //Toast.makeText(getActivity(), "Se perdio la conexión, se guardo la edicion en local", Toast.LENGTH_LONG).show();
                actualizarAvalEnSQLite(nombreAv, direccionAv, telefonoAv, orAv, garantiasAv, ruta_id, poblacion_id, colocadora_id, "", "off", "");
                actualizarClienteEnSQLite(cliente_id, nombre, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id, "", "off", "");

                // Crear un MaterialAlertDialog personalizado
                LayoutInflater inflater = getLayoutInflater();
                View dialogView = inflater.inflate(R.layout.dialog_success, null);

                // Encuentra el TextView y asigna el texto dinámico
                TextView messageText = dialogView.findViewById(R.id.message_text);
                messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                builder.setView(dialogView); // Usa el layout personalizado

                AlertDialog confirmationDialog = builder.create();
                confirmationDialog.show();

                // Cerrar automáticamente el diálogo después de 3 segundos
                new Handler().postDelayed(() -> {
                    confirmationDialog.dismiss(); // Cerrar el diálogo después de 3 segundos

                    // Realizar la navegación después de que el diálogo se haya cerrado
                    NavOptions navOptions = new NavOptions.Builder()
                            .setPopUpTo(R.id.nav_clientes, true) // Se asegura de que el fragmento nav_clientes sea el principal
                            .build();

                    // Navegar al fragmento nav_clientes
                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes, null, navOptions);
                }, 3000); // Retardo de 3 segundos antes de la navegación
            }
        });
    }
    private void actualizarClienteEnSQLite(String clienteId, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String ruta_id2, String poblacion_id2, String colocadora_id2, String updatedAt, String on, String idAval) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Crear los valores a actualizar para la tabla de clientes
        ContentValues valores = new ContentValues();
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("garantias", garantias);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("ruta_id", ruta_id2);
        valores.put("poblacion_id", poblacion_id2);
        valores.put("colocadora_id", colocadora_id2);

        // Obtener el timestamp actual
        long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));

        if (!updatedAt.isEmpty()) {
            valores.put("updated_at", updatedAt);
        } else {
            valores.put("updated_at", formattedDate);
        }

        if (idAval != null && !idAval.isEmpty()) {
            valores.put("aval_id", idAval);
        }
        else
        {
            valores.put("aval_id", aval_id);
        }



        // Actualizar el cliente en la base de datos
        int filasActualizadas = db.update("clientes", valores, "id = ?", new String[]{clienteId});

        if (filasActualizadas > 0) {
            Log.d("SQLite", "Cliente actualizado en SQLite Con ID AVAL: " + aval_id + " y fecha updated_at: " + formattedDate);
        } else {
            Log.d("SQLite", "No se pudo actualizar el Cliente en SQLite");
        }

        // Actualizar el aval_id del préstamo más reciente del cliente
        try {
            // Consultar el ID del préstamo más reciente del cliente
            String queryPrestamo = "SELECT id FROM prestamos WHERE cliente_id = ? ORDER BY id DESC LIMIT 1";
            Cursor cursor = db.rawQuery(queryPrestamo, new String[]{clienteId});

            if (cursor != null && cursor.moveToFirst()) {
                String prestamoId = cursor.getString(0); // ID del préstamo más reciente

                // Crear los valores a actualizar para la tabla de préstamos
                ContentValues valoresPrestamo = new ContentValues();

                valoresPrestamo.put("aval_id", aval_id);

                // Actualizar el aval_id en la tabla de préstamos
                int filasPrestamoActualizadas = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{prestamoId});

                if (filasPrestamoActualizadas > 0) {
                    Log.d("SQLite", "Préstamo actualizado con nuevo aval_id: " + aval_id);
                } else {
                    Log.d("SQLite", "No se pudo actualizar el aval_id del préstamo más reciente.");
                }

                cursor.close();
            } else {
                Log.d("SQLite", "No se encontró un préstamo reciente para el cliente con ID: " + clienteId);
            }
        } catch (Exception e) {
            Log.e("SQLite", "Error al actualizar el aval_id del préstamo: " + e.getMessage());
        } finally {
            db.close(); // Cerrar la conexión a la base de datos
        }
    }


    private void actualizarAvalEnSQLite(String nombre, String direccion, String telefono, String otrasReferencias, String garantias,
                                        String ruta_id2, String poblacion_id2, String colocadora_id2, String updatedAt, String online, String idAval) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        Log.d("SQLite", "AVAL SELECCIONADO......................... ID: " + aval_id);

        // Realizar inserción solo si el aval_id es null o está vacío
        if (aval_id == null || aval_id.isEmpty()) {

            if (online.equals("off")) {
                SolicitudSubida solicitud = new SolicitudSubida(archivosGeneral, nombre, direccion, telefono, otrasReferencias, garantias, ruta_id2, poblacion_id2, colocadora_id2, "0", "0", "InsertAval", cliente_id,"");
                colaSolicitudes.agregarSolicitud(solicitud);
            }
            if (idAval != null && !idAval.isEmpty()) {
                Log.d("Updated At", "ENTRO EN IF idAval NO ES NULO...............................................");
                aval_id = idAval;
            }
            else
            {
                aval_id = String.valueOf(obtenerSiguienteIdAval(db)); // Generar nuevo ID
            }
            Log.d("SQLite", "AVAL DESPUÉS DE obtenerSiguienteIdAval......................... ID: " + aval_id);

            // Crear valores para insertar
            ContentValues valoresAval = new ContentValues();
            valoresAval.put("id", aval_id);
            valoresAval.put("nombre_completo", nombre != null ? nombre : "Nombre por Definir");
            valoresAval.put("direccion", direccion != null ? direccion : "Dirección por Definir");
            valoresAval.put("telefono", telefono != null ? telefono : "Teléfono por Definir");
            valoresAval.put("garantias", garantias != null ? garantias : "Garantías por Definir");
            valoresAval.put("otras_referencias", otrasReferencias != null ? otrasReferencias : "Referencias por Definir");
            valoresAval.put("ruta_id", ruta_id2 != null ? ruta_id2 : "1");
            valoresAval.put("poblacion_id", poblacion_id2 != null ? poblacion_id2 : "1");
            valoresAval.put("colocadora_id", colocadora_id2 != null ? colocadora_id2 : "1");

            // Intentar insertar en la base de datos
            long nuevoAvalId = db.insertWithOnConflict("avales", null, valoresAval, SQLiteDatabase.CONFLICT_REPLACE);
            if (nuevoAvalId != -1) {
                Log.d("SQLite", "Nuevo aval insertado con........................... ID: " + aval_id);
            } else {
                Log.e("SQLite", "Error al insertar el nuevo aval.........................");
                db.close();
                return; // Si no se pudo insertar, terminar la función
            }
        } else {
            Log.d("SQLite", "Nuevo aval ID: " + aval_id + ". No se realizará una nueva inserción.");

            // Actualizar los datos del aval existente
            long timestamp = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
            String formattedDate = sdf.format(new Date(timestamp));

            ContentValues valores = new ContentValues();
            valores.put("nombre_completo", nombre);
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", ruta_id2);
            valores.put("poblacion_id", poblacion_id2);
            valores.put("colocadora_id", colocadora_id2);
            valores.put("updated_at", formattedDate);

            // Intentar actualizar el aval
            int filasAfectadas = db.update("avales", valores, "id = ?", new String[]{aval_id});

            if (filasAfectadas > 0) {
                Log.d("SQLite", "AVAL actualizado en SQLite con ID: " + aval_id);
            } else {
                Log.d("SQLite", "No se encontró el AVAL con ID: " + aval_id + ". No se actualizó.");
            }
        }
        db.close(); // Cerrar conexión
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    public byte[] getFileDataFromDrawable(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 80, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream byteBuff = new ByteArrayOutputStream();

        int buffSize = 1024;
        byte[] buff = new byte[buffSize];

        int len = 0;
        while ((len = is.read(buff)) != -1) {
            byteBuff.write(buff, 0, len);
        }

        return byteBuff.toByteArray();
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }
    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, fos);
        fos.flush();
        fos.close();
        return file;
    }
    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }
    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 40, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(ClientesEditarViewModel.class);
        // TODO: Use the ViewModel
    }

}